﻿Public Class Form1
    'Panasonic TV commande
    Dim PON_FAKE() As Byte = {&H2, &H50, &H50, &H4E, &H3}
    Dim PON() As Byte = {&H2, &H50, &H4F, &H4E, &H3}
    Dim POF() As Byte = {&H2, &H50, &H4F, &H46, &H3}
    Dim VOL_UP() As Byte = {&H2, &H41, &H56, &H4C, &H3A, Volume_Digit_1, Volume_Digit_2, &H3} 'Augmente de 10 STX AVL:10 ETX
    Dim Mute_1() As Byte = {&H2, &H41, &H4D, &H54, &H3A, &H31, &H3}                           'Mute STX AMT:1 ETX
    Dim Mute_0() As Byte = {&H2, &H41, &H4D, &H54, &H3A, &H30, &H3}                           'Mute STX AMT:0 ETX


    'Sharp TV commande
    Dim POWR_ON() As Byte = {&H50, &H4F, &H57, &H52, &H31, &H20, &H20, &H20, &HD}             'POWR1
    Dim POWR_OFF() As Byte = {&H50, &H4F, &H57, &H52, &H30, &H20, &H20, &H20, &HD}            'POWR0
    Dim RSPW_1() As Byte = {&H52, &H53, &H50, &H57, &H31, &H20, &H20, &H20, &HD}
    Dim Mute_1_Sharp() As Byte = {&H4D, &H55, &H54, &H45, &H31, &H20, &H20, &H20, &HD}        'Mute
    Dim Mute_2_Sharp() As Byte = {&H4D, &H55, &H54, &H45, &H32, &H20, &H20, &H20, &HD}
    Dim VOLM() As Byte = {&H56, &H4F, &H4C, &H4D, Volume_Digit_1, Volume_Digit_2, &H20, &H20, &HD}

    Dim Volume As Integer
    Dim Volume_Digit_1 As Integer
    Dim Volume_Digit_2 As Integer
    Dim Port_selected As String
    Dim TV_selected As String
    Dim Port_names_listing As String()
    Dim TV_answer As String
    Dim Pause_time_ms As Integer = 600

    Public IniPath As String = Application.StartupPath & "\data.ini" 'Répertoire Ini dans le dossier de l'application courante
    Public Filename As String = System.IO.Path.GetFileName(IniPath) 'Va chercher le nom du fichier ini sans le répertoire
    Public objIniFile As New IniFile(Application.StartupPath & "\data.ini")


    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed

        SerialPort1.Close()
        'Sauvegarde le nom du port dans data.ini
        objIniFile.WriteString("Settings", "Port_selected", Port_selected)
        'Sauvegarde le nom de la TV dans data.ini
        objIniFile.WriteString("Settings", "TV_selected", TV_selected)

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        If System.IO.File.Exists(IniPath) Then
            'Si le fichier existe, va chercher les derniers paramètres
            Port_selected = objIniFile.GetString("Settings", "Port_selected", "(none)")
            TV_selected = objIniFile.GetString("Settings", "TV_selected", "(none)")


        Else
            'Crée le .ini si il n'existe pas
            objIniFile.WriteString("Settings", "Port_selected", "")
            objIniFile.WriteString("Settings", "TV_selected", "")
            Port_selected = ""

        End If


        Serial_Port_Detection()



        If TV_selected = "" Then

            TV_selected = "Sharp"

            TV_Box.SelectedItem = TV_selected

        Else

            TV_Box.SelectedItem = TV_selected

        End If


        'set-up timers
        Timer1.Interval = 10 '10ms
        Timer1.Enabled = True 'start timer
        COM_Select_Box.SelectedItem = Port_selected   'Met le premier port trouvé dans la boite de sélection


    End Sub
    Public Sub Serial_Port_Detection()

        Port_names_listing = System.IO.Ports.SerialPort.GetPortNames() ' Va chercher le nom des ports séries

        For I = 0 To (Port_names_listing.Length - 1)            'Remplie la boite de selection avec les noms des ports disponibles

            COM_Select_Box.Items.Add(Port_names_listing(I))

        Next I


        If Port_names_listing(0) = "" Then

            MsgBox("Aucun port détecté!")

        Else



            If Port_selected = "" Then   'Si il n'y a pas de port enregistré va chercher le premier trouvé

                Port_selected = Port_names_listing(0)

            Else
                'Va chercher le dernier port utilisé  
                Port_selected = objIniFile.GetString("Settings", "Port_selected", "(none)")
            End If


            Try

                Open_com_port()

            Catch ex As Exception

                'MessageBox.Show("Le " & Port_selected & " est déja utilisé")

            End Try

        End If



    End Sub
    'Allume la télévision
    Private Sub Allumer_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Allumer_Button.Click

        Dim path As String
        'Va chercher le dossier dans lequel le programme est éxécuté
        path = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase)

        'Met les écrans en mode étendues
        'Process.Start(path & "\dc2.exe", "-configure=""MODE_ETENDUE.xml""")


        Select Case (TV_selected)
            Case "Panasonic"
                SerialPort1.Write(PON, 0, PON.Length)
            Case "Sharp"
                SerialPort1.Write(POWR_ON, 0, POWR_ON.Length)
        End Select

        'Pause
        System.Threading.Thread.Sleep(Pause_time_ms)

        'Si le buffer est vide n'affiche rien
        If TV_answer = "" Then

            'Sinon affiche la réponse de la TV dans la AnswerBox
        Else

            Answer_Box.Text = TV_answer

        End If



    End Sub
    'Éteint la télévision
    Private Sub Eteindre_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Eteindre_button.Click


        Dim path As String
        'Va chercher le répertoire dans lequel le programme est exécuté
        path = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase)
        'Met un écran actif seulement désactivé pour le moment
        'Process.Start(path & "\dc2.exe", "-configure=""MODE_1_ECRAN.xml""")

        TV_answer = SerialPort1.ReadExisting()

        Select (TV_selected)
            Case "Panasonic"

                SerialPort1.Write(POF, 0, POF.Length)
                

            Case "Sharp"

                SerialPort1.Write(POWR_OFF, 0, POWR_OFF.Length)
                
        End Select


        'Pause
        System.Threading.Thread.Sleep(Pause_time_ms)

        'Si le buffer est vide affiche rien 
        If TV_answer = "" Then

            'Sinon affiche la réponse de la TV dans la AnswerBox
        Else

            Answer_Box.Text = TV_answer

        End If

    End Sub
    'Mute le volume de la télévision
    Private Sub Mute_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Mute_Button.Click

        Select Case (TV_selected)
            Case "Panasonic"

                If Mute_Button.Text = "MUTE OFF" Then   'toggle
                    Mute_Button.Text = "MUTE ON"
                    Mute_Button.ForeColor = Color.Red
                    SerialPort1.Write(Mute_1, 0, Mute_1.Length)

                ElseIf Mute_Button.Text = "MUTE ON" Then
                    Mute_Button.Text = "MUTE OFF"
                    Mute_Button.ForeColor = Color.Green

                    SerialPort1.Write(Mute_0, 0, Mute_0.Length)
                End If


            Case "Sharp"

                If Mute_Button.Text = "MUTE OFF" Then   'toggle
                    Mute_Button.Text = "MUTE ON"
                    Mute_Button.ForeColor = Color.Red
                    SerialPort1.Write(Mute_1_Sharp, 0, Mute_1_Sharp.Length)

                ElseIf Mute_Button.Text = "MUTE ON" Then
                    Mute_Button.Text = "MUTE OFF"
                    Mute_Button.ForeColor = Color.Green
                    SerialPort1.Write(Mute_2_Sharp, 0, Mute_2_Sharp.Length)
                End If


        End Select






        'Pause
        System.Threading.Thread.Sleep(Pause_time_ms)

        If TV_answer = "" Then

        Else
            'Sinon affiche la réponse de la TV dans la AnswerBox

            Answer_Box.Text = TV_answer

        End If


    End Sub

    Private Sub Timer1_Tick_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        ProgressBar1.Value = TrackBar1.Value
    End Sub

    Private Sub TrackBar1_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.Scroll

        Volume = TrackBar1.Value


        Volume_Digit_1 = Asc(Mid(Volume, 1, 1))  'converti en ascii


        Try
            Volume_Digit_2 = Asc(Mid(Volume, 2, 1)) 'converti en ascii (Try pour éviter l'exception avec le zéro)

        Catch ex As Exception



        End Try


        Select Case (TV_selected)

            Case "Panasonic"

                If Volume > 9 Then
                    VOL_UP = {&H2, &H41, &H56, &H4C, &H3A, Volume_Digit_1, Volume_Digit_2, &H3} 'Augmente de 10 STX AVL:10 ETX
                Else
                    VOL_UP = {&H2, &H41, &H56, &H4C, &H3A, Volume_Digit_2, Volume_Digit_1, &H3} 'Augmente de 10 STX AVL:10 ETX
                End If

                SerialPort1.Write(VOL_UP, 0, VOL_UP.Length)

            Case "Sharp"

                If Volume > 9 Then
                    VOLM = {&H56, &H4F, &H4C, &H4D, Volume_Digit_1, Volume_Digit_2, &H20, &H20, &HD}
                Else
                    VOLM = {&H56, &H4F, &H4C, &H4D, Volume_Digit_2, Volume_Digit_1, &H20, &H20, &HD}
                End If

                SerialPort1.Write(VOLM, 0, VOLM.Length)

        End Select


    End Sub

    Private Sub COM_Select_Box_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles COM_Select_Box.SelectedIndexChanged

        SerialPort1.Close()

        Select Case (COM_Select_Box.SelectedIndex)


            Case 0
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 1

                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 2
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 3
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()
            Case 4
                Port_selected = COM_Select_Box.SelectedItem
                Open_com_port()

        End Select

        'Sauvegarde le nom du port dans data.ini
        objIniFile.WriteString("Settings", "Port_selected", Port_selected)



    End Sub

    Public Sub Open_com_port()

        SerialPort1.PortName = Port_selected
        SerialPort1.BaudRate = 9600
        SerialPort1.DataBits = 8
        SerialPort1.Parity = IO.Ports.Parity.None
        SerialPort1.StopBits = IO.Ports.StopBits.One
        SerialPort1.Open()


    End Sub




    Private Sub TV_Box_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TV_Box.SelectedIndexChanged


        Select (TV_Box.SelectedIndex)


            Case 0
                TV_selected = "Panasonic"

            Case 1

                TV_selected = "Sharp"

        End Select

        'Sauvegarde le nom de la TV dans data.ini
        objIniFile.WriteString("Settings", "TV_selected", TV_selected)



    End Sub

    'Ceci est exécuté lorsqu'on recoit des datas sur le port série
    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived


        'Pause pendant qu'on lit sur le port
        System.Threading.Thread.Sleep(300)

        'Déplace les datas recu dans le buffer
        TV_answer = (SerialPort1.ReadExisting)

    End Sub
End Class




